# **Host-Based Intrusion Prevention System (HIPS)**

- **Definition:** A software package that detects and prevents attacks on the host on which it is installed.
- **Function:** Monitors a host for suspicious activity by analyzing events.
- **Goal:** To stop malware by monitoring the behavior of code.

## **1. Similarities to Network-Based IPS**

- Uses the same technologies to detect suspicious activity.
- Can take similar actions upon detecting suspicious or malicious activity.
- Can generate the same types of alarms.

## **2. Advantages of HIPS**

- Installed directly on the host it protects.
- Can monitor processes and resources on the system.
- Can analyze encrypted traffic _after_ it has been decrypted (network-based IPS cannot).

## **3. Actions Upon Detecting Suspicious Activity**

- Blocks the action.
- Alerts the user.
- **Examples of Suspicious Activity:**
    - Taking control of other programs.
    - Ending other programs.
    - Changing important registry keys.

## **4. Technologies Used for Detection**

- **Signature-based IPS:**
    - Compares traffic to a set of rules called signatures.
    - Takes action (e.g., dropping packets, logging, alerting) when traffic matches a signature.
    - Signatures are developed by engineers who research known attacks and vulnerabilities.
    - **Limitation:** Cannot detect unknown attacks for which there is no signature.
- **Anomaly-based IPS:**
    - Compares real-time traffic to traffic considered "normal."
    - Requires establishing a baseline to define normal traffic.
- **Policy-based IPS:**
    - Compares real-time traffic to preconfigured policies.
- **Combination:** HIPS can use any combination of the above detection methods.